// eslint-disable-next-line @typescript-eslint/ban-ts-ignore
// @ts-ignore
import { parseWikiMd } from '@yandex-int/remark-woofmd';
import { create, IWoofSettings } from '@yandex-int/woof';
// eslint-disable-next-line @typescript-eslint/ban-ts-ignore
// @ts-ignore
import { formatMdAst } from '@yandex-int/woofmd-to-bemjson';
import LRU from 'lru-cache';
import md5 from 'md5';

const cache = new LRU<string, Promise<string | undefined>>({
    maxAge: 1000 * 60 * 60 * 24 * 30, // 30 day
    max: 600 // max count fields in the cache
});

const FORMATTER_CONFIG: IWoofSettings = {
    lang: 'en',
    platform: 'desktop',
    instance: 'business',
    // eslint-disable-next-line @typescript-eslint/camelcase
    forms_url: '',
    // eslint-disable-next-line @typescript-eslint/camelcase
    wiki_url: '',
    // eslint-disable-next-line @typescript-eslint/camelcase
    wiki_api_url: '',
    // eslint-disable-next-line @typescript-eslint/camelcase
    docviewer_url: '',
    // eslint-disable-next-line @typescript-eslint/camelcase
    charts_url: '',
    // eslint-disable-next-line @typescript-eslint/camelcase
    statface_url: '',
    // eslint-disable-next-line @typescript-eslint/camelcase
    yastatic_url: '',
    orgId: ''
};

const formatter = create(FORMATTER_CONFIG);
const configFormatter = formatter.getConfig();

async function formatText(text: string): Promise<string> {
    const ast = parseWikiMd(text, configFormatter);
    const bemjson = await formatMdAst(ast, configFormatter);

    // Хак: Переопределяю wiki-аттрибуты в результирующем bemjson,
    // чтобы в html не выливать много лишнего кода
    bemjson['wiki-attrs'] = FORMATTER_CONFIG;

    const formattedRes = await formatter.bemjsonToHtml(bemjson);

    // Хак: replace нужен, чтобы у ссылок не было title
    return formattedRes.replace(
        /title="External link \(opens in new window\)"/gim,
        ''
    );
}

export default function getFormattedText(text: string): Promise<string> {
    const cacheName = md5(text);

    if (!cache.has(cacheName)) {
        cache.set(cacheName, formatText(text));
    }

    // eslint-disable-next-line @typescript-eslint/ban-ts-ignore
    // @ts-ignore
    return cache
        .get(cacheName)
        .then((formattedText: string) => {
            if (formattedText) {
                return formattedText;
            }

            cache.del(cacheName);

            return text;
        })
        .catch((error: Error) => {
            console.error(error);
            cache.del(cacheName);

            return text;
        });
}

type Items = {
    title: string;
    text: string;
    popup?: string;
};

export function formatTextsToWiki(items: Items[]): Promise<Items[]> {
    return Promise.all(
        items.map(async (item) => {
            const preparedItem = { ...item };
            if (item.popup) {
                preparedItem.popup = await getFormattedText(item.popup);
            }

            preparedItem.text = await getFormattedText(item.text);

            return preparedItem;
        })
    );
}
