import path from 'path';

import { IS_DEV } from './env';

export const ROOT_DIR_FROM_WEBPACK = path.join(__dirname, '../');
export const ROOT_DIR_FROM_DIST_SERVER = path.join(__dirname, '..', '..');

export const ROOT_DIR = IS_DEV
    ? ROOT_DIR_FROM_DIST_SERVER // In DEV mode webpack is running from %project-root%/dist/server
    : ROOT_DIR_FROM_WEBPACK; // Otherwise from %project-root%/webpack

export const DIST_DIR = path.join(ROOT_DIR, 'dist');
export const SERVER_DIR = path.join(ROOT_DIR, 'server');
export const CLIENT_DIR = path.join(ROOT_DIR, 'client');

/*
export const CSS_LEGO_VARIABLES_FILE = path.join(
    ROOT_DIR, 'node_modules', 'Theme', 'presets', 'default.css'
);
*/
