import path from 'path';

import cssnano from 'cssnano';
import MiniCssExtractPlugin from 'mini-css-extract-plugin';
import postcssCustomMedia from 'postcss-custom-media';
import postcssCustomProperties from 'postcss-custom-properties';
import postcssImport from 'postcss-import';
import postcssNested from 'postcss-nested';
import postcssPrependImports from 'postcss-prepend-imports';
import postcssReporter from 'postcss-reporter';
// import themeFold from 'postcss-theme-fold';
import webpack from 'webpack';

// import { CLIENT_DIR, CSS_LEGO_VARIABLES_FILE } from '../dir';
import { CLIENT_DIR } from '../dir';
import { IS_DEV } from '../env';

const postcssLoader = {
    loader: 'postcss-loader',
    options: {
        plugins: [
            postcssPrependImports({
                path: path.resolve(CLIENT_DIR, 'styles'),
                files: ['fonts.css', 'variables.css']
            }),
            postcssImport(),
            postcssNested(),
            postcssCustomMedia({ preserve: false }),
            postcssCustomProperties({ preserve: false }),
            // themeFold({ themes: [[CSS_LEGO_VARIABLES_FILE]] }),
            !IS_DEV && cssnano({ preset: 'default' }),
            postcssReporter()
        ].filter(Boolean)
    }
};

const cssLoader = {
    loader: 'css-loader'
};

export default {
    client: {
        test: /\.css$/,
        use: [
            IS_DEV && 'css-hot-loader',
            MiniCssExtractPlugin.loader,
            cssLoader,
            postcssLoader
        ].filter(Boolean) as webpack.Loader[]
    },

    ssr: {
        test: /\.css$/,
        loader: 'null-loader'
    }
};
