import { join } from 'path';

import cfg from '@yandex-int/yandex-cfg';
import { TsconfigPathsPlugin } from 'tsconfig-paths-webpack-plugin';
import webpack from 'webpack';
import nodeExternals from 'webpack-node-externals';

import { ROOT_DIR_FROM_WEBPACK } from './dir';
import * as loaders from './loaders';

function getConfig(lang: string): webpack.Configuration {
    return {
        name: `ssr_bundles_${lang}`,
        target: 'node',
        node: { __dirname: false },
        devtool: 'source-map',
        entry: join(ROOT_DIR_FROM_WEBPACK, 'client', 'bundles', 'index.ts'),
        output: {
            filename: `ssr.bundles.${lang}.js`,
            libraryTarget: 'commonjs2',
            path: join(ROOT_DIR_FROM_WEBPACK, 'dist'),
            publicPath: '/static/'
        },
        resolve: {
            extensions: ['.js', '.ts', '.tsx'],
            plugins: [new TsconfigPathsPlugin()]
        },
        externals: [
            nodeExternals({
                whitelist: [
                    /\.(?!(?:jsx?|json)$).{1,5}$/i,
                    /lego-on-react/,
                    /@yandex-lego/
                ]
            })
        ],
        module: {
            rules: [
                loaders.legoI18N,
                loaders.css.ssr,
                loaders.typescript.ssr,
                loaders.file.ssr,
                loaders.url,
                loaders.svg.ssr
            ]
        },
        plugins: [
            new webpack.DefinePlugin({
                'process.env.BEM_LANG': JSON.stringify(lang)
            })
        ],
        optimization: { nodeEnv: false },
        stats: 'errors-only'
    };
}

export default cfg.i18n.langs.map(getConfig);
