import 'csp-header';

declare module 'csp-header' {
    type reportUriHandler = (req: Request, res: Response) => string;

    interface Params {

        /** Instructs the browser to only send reports (does not block anything) */
        reportOnly?: boolean;

        /** Instructs the browser to POST reports of policy failures to this URI */
        reportUri?: string | reportUriHandler;

        /** Service identificator (required if useDefaultReportUri is on) */
        serviceName?: string;

        /**
         * Instructs the browser to use https://csp.yandex.net/csp as recommended report URI
         *
         * See https://wiki.yandex-team.ru/product-security/csp/#prijomotchetovonarushenijax
         */
        useDefaultReportUri?: boolean;
    }
}
