declare namespace Express {
    interface Request {

        /**
         * Cryptographic nonce which is used to mark scripts as approved,
         * generated by express-yandex-csp middleware
         *
         * Source code:
         * https://github.yandex-team.ru/toolbox/express-yandex-csp
         *
         * More about CSP headers:
         * https://content-security-policy.com/
         * https://www.w3.org/TR/CSP3/
         */
        nonce?: string;
    }
}

declare module '@yandex-int/express-yandex-csp' {
    import { Params, Policies } from 'csp-header';
    import { RequestHandler } from 'express';

    /**
     * Sets Content Security Policy headers
     * and adds nonce to the Request object
     *
     * Source code:
     * https://github.yandex-team.ru/toolbox/express-yandex-csp
     *
     * More about CSP headers:
     * https://content-security-policy.com/
     * https://www.w3.org/TR/CSP3/
     */
    function expressYandexCsp(options?: Params): RequestHandler;

    export type Presets = Policies[];

    export { Params as ExpressYandexCspOptions };
    export { EVAL, INLINE, NONE, SELF } from 'csp-header';
    export { NONCE, TLD } from 'express-csp-header';

    export default expressYandexCsp;
}
