// eslint-disable-next-line @typescript-eslint/no-unused-vars
import { Logger } from '@yandex-int/yandex-logger';

import './files/gif';
import './files/jpeg';
import './files/jpg';
import './files/png';
import './files/svg';
import './files/webp';
import './vendors-manifest';

// eslint-disable-next-line @typescript-eslint/no-unused-vars
import { BundleData, BunkerData, PageName, SecFiling } from 'client/bundles/types';

declare global {
    // tslint:disable-next-line:no-any
    interface Window { easyXDM: any; }

    namespace Express {
        interface Request {

            /** Logger instance associated with current request */
            logger: Logger;

            secFilings: SecFiling[];

            baseUrl: string;

            bunker: BunkerData;
        }

        interface Response {

            /**
             * Renders bundle to html, then sends it
             * or performs redirect if necessary
             */
            // tslint:disable-next-line:no-any
            renderBundle(bundleName: string, pageName: PageName, data: BundleData): void;
        }

        interface Application {
            redirect(from: string, to: string, code: number): void;
        }
    }
}
