import React, { Component, Fragment } from 'react';
import { hydrate } from 'react-dom';
import Helmet from 'react-helmet';
import { hot } from 'react-hot-loader/root';

import { BrowserRouter } from 'react-router-dom';

import App from 'client/components/app/app';

import { BundleData, BundleProps } from './types';

import './desktop.css';

class Bundle extends Component<BundleProps> {
    render() {
        const { data } = this.props;
        const description = 'The Investor Relations website contains information about Yandex N.V.\'s business for ' +
            'stockholders, potential investors, and financial analysts.';
        const siteName = 'Investor Relations, Yandex N.V.';
        const image = 'https://ir-docs.s3.yandex.net/og/Yandex.png';

        return (
            <Fragment>
                <Helmet>
                    <html />
                    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
                    <link rel="canonical" href={data.baseUrl} />
                    <meta name="description" content={description} />

                    <meta property="og:url" content={data.baseUrl} />
                    <meta property="og:type" content="website" />
                    <meta property="og:site_name" content={siteName} />
                    <meta property="og:description" content={description} />
                    <meta property="og:image" content={image} />
                    <meta property="og:image:width" content="250" />
                    <meta property="og:image:height" content="250" />

                    <meta name="twitter:site" content={siteName} />
                    <meta property="twitter:description" content={description} />
                    <meta name="twitter:card" content={image} />

                    <link rel="shortcut icon" href="https://ir-docs.s3.yandex.net/og/favicon.ico" />
                    <link rel="shortcut icon" href="https://yastatic.net/s3/home-static/_/92/929b10d17990e806734f68758ec917ec.png" sizes="32x32" />
                    <link rel="shortcut icon" href="https://yastatic.net/s3/home-static/_/7c/7ccfee6f1e81b14c5bef535d1ad7b7e0.png" sizes="192x192" />
                    <link rel="apple-touch-icon" href="https://yastatic.net/s3/home-static/_/64/64f5920e670ad193dcca0ed33500c7c4.png" sizes="76x76" />
                    <link rel="apple-touch-icon" href="https://yastatic.net/s3/home-static/_/dd/dd7dd21686a67bfa46910039ead07a04.png" sizes="120x120" />
                    <link rel="apple-touch-icon" href="https://yastatic.net/s3/home-static/_/75/759c668aa6747fee858fb5ae0c207474.png" sizes="152x152" />
                    <link rel="apple-touch-icon" href="https://yastatic.net/s3/home-static/_/90/9034470dfcb0bea0db29a281007b8a38.png" sizes="180x180" />
                </Helmet>

                <App {...this.props} />
            </Fragment>
        );
    }
}

export const DesktopBundle = hot(Bundle);

export default (data: BundleData) => {
    hydrate(
        <BrowserRouter>
            <DesktopBundle data={data} />
        </BrowserRouter>,
        document.getElementById('mount')
    );
};
