import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { Analyst, BunkerAnalysts } from 'client/bundles/types';
import './index.css';

const b = cn('analysts');
const bPageTitle = cn('page-title');

interface Props {
    analystsData?: BunkerAnalysts;
}

class Analysts extends Component<Props> {
    renderListHead = () => {
        return (
            <div className={b('list-head')}>
                <div className={b('list-firm')}>Firm</div>
                <div className={b('list-person')}>Person</div>
                <div className={b('list-email')}>Email</div>
            </div>
        );
    }

    renderList = (analysts: Analyst[]) => {
        return (analysts.map(this.renderListItem));
    }

    renderListItem = (listItem: Analyst, index: number) => {
        return (
            <div key={index} className={b('list-item')}>
                <div className={b('list-firm')}>{listItem.firm}</div>
                <div className={b('list-person')}>{listItem.person}</div>
                <div className={b('list-email')}>
                    <a
                        className={b('email-link')}
                        href={`mailto:${listItem.email}`}
                        rel="nofollow"
                        >
                        {listItem.email}
                    </a>
                </div>
            </div>
        );
    }

    render() {
        if (!this.props.analystsData) {
            return null;
        }

        const { title, analysts, text } = this.props.analystsData;

        return (
            <div className={b()}>
                <h1 className={bPageTitle({ type: 'border' })}>{title}</h1>

                <div className={b('list')}>
                    { this.renderListHead() }
                    { this.renderList(analysts) }
                </div>

                <p className={b('note')}>{text}</p>
            </div>
        );
    }

}

export default Analysts;
