import cn from 'client/utils/cn';

import { cnTheme } from '@yandex-lego/components/Theme';
import { theme } from '@yandex-lego/components/Theme/presets/default';

import Footer from 'client/components/footer';
import Header from 'client/components/header';
import LogoPrint from 'client/components/logo-print';
import Metrika from 'client/components/metrika';
import Prefooter from 'client/components/prefooter';

import AnalystsPage from 'client/pages/analysts/analysts';
import BondsPage from 'client/pages/bonds/bonds';
import ContactsGovernancePage from 'client/pages/contacts-governance/contacts-governance';
import ContactsPage from 'client/pages/contacts/contacts';
import DirectorsPage from 'client/pages/directors/directors';
import EmailAlertsPage from 'client/pages/email-alerts/email-alerts';
import EventsPage from 'client/pages/events/events';
import FaqGovernancePage from 'client/pages/faq-governance/faq-governance';
import FaqPage from 'client/pages/faq/faq';
import FinancialsPage from 'client/pages/financials/financials';
import KeyBusinessesPage from 'client/pages/key-businesses/key-businesses';
import KeyDocumentsPage from 'client/pages/key-documents/key-documents';
import LatestPresentationPage from 'client/pages/latest-presentation/latest-presentation';
import MainPage from 'client/pages/main/main';
import ManagementPage from 'client/pages/management/management';
import MeetingsPage from 'client/pages/meetings/meetings';
import NotFoundPage from 'client/pages/not-found/not-found';
import PrinciplesPage from 'client/pages/our-principles/our-principles';
import OverviewPage from 'client/pages/overview/overview';
import PressReleasesPage from 'client/pages/press-releases/press-releases';
import SecPage from 'client/pages/sec/sec';
import StocksPage from 'client/pages/stocks/stocks';
import StructurePage from 'client/pages/structure/structure';
import SustainabilityPage from 'client/pages/sustainability/sustainability';
import WebcastPage from 'client/pages/webcast/webcast';

import React, { Component } from 'react';

import { BundleProps, PageName } from 'client/bundles/types';

import 'client/components/page-title/index.css';
import './app.css';

const b = cn('app');

const PAGES: Record<PageName, typeof Component> = {
    analysts: AnalystsPage,
    bonds: BondsPage,
    contacts: ContactsPage,
    emailAlerts: EmailAlertsPage,
    faq: FaqPage,
    financials: FinancialsPage,
    events: EventsPage,
    main: MainPage,
    meetings: MeetingsPage,
    sec: SecPage,
    stocks: StocksPage,
    keyDocuments: KeyDocumentsPage,
    overview: OverviewPage,
    directors: DirectorsPage,
    notFound: NotFoundPage,
    pressReleases: PressReleasesPage,
    structure: StructurePage,
    management: ManagementPage,
    contactsGovernance: ContactsGovernancePage,
    faqGovernance: FaqGovernancePage,
    ourPrinciples: PrinciplesPage,
    keyBusinesses: KeyBusinessesPage,
    sustainability: SustainabilityPage,
    latestPresentation: LatestPresentationPage,
    webcast: WebcastPage
};

interface State {
    isMenuOpened: boolean;
}

class App extends Component<BundleProps, State> {
    constructor(props: BundleProps) {
        super(props);

        this.state = {
            isMenuOpened: false
        };
    }

    onNavToggled = (opened: boolean) => {
        this.setState({ isMenuOpened: opened });
    }

    render() {
        const { data } = this.props;
        const PageContent = PAGES[data.pageName];
        const isMainPage = data.pageName === 'main';

        return (
            <div
                className={b({
                    'nav_opened': this.state.isMenuOpened,
                    'main-page': isMainPage },
                [cnTheme(theme)])}
                >
                <LogoPrint />

                <Header
                    items={data.menu}
                    isTestingEnv={data.isTestingEnv}
                    isMenuOpened={this.state.isMenuOpened}
                    onNavToggled={this.onNavToggled}
                    />

                <div className={b('content')}>
                    <div className={b('content-inner')}>
                        <PageContent data={data} />
                    </div>
                </div>

                <Prefooter {...data.prefooter} />

                <Footer />

                <Metrika metrika={data.metrika} />
            </div>
        );
    }
}

export default App;
