import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

const b = cn('ask-form');
const bPageTitle = cn('page-title');

interface Props {
    title: string;
    askFormUrl: string;
}

class AskForm extends Component<Props> {
    render() {
        return (
            <div className={b('')}>
                <h1 className={bPageTitle({ type: 'border' })}>{this.props.title}</h1>

                <div className={b('content')}>
                    <iframe
                        className={b('iframe')}
                        src={this.props.askFormUrl}
                        name="askIRForm"
                        />
                </div>
            </div>
        );
    }
}

export default AskForm;
