import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

const b = cn('breadcrumbs');

interface Props {
    text: string | undefined;
    link: string;
}

class Breadcrumbs extends Component<Props> {
    render() {
        const { text, link } = this.props;

        return (
            text ?
                <div className={b()}>
                    <a href={link} className={b('link')}>
                        <i className={b('icon')} />
                        {text}
                    </a>
                </div> :
                null
        );
    }
}

export default Breadcrumbs;
