import cn from 'client/utils/cn';
import React, { Component } from 'react';

import Button from 'client/components/lego/button';
import Slider2 from 'client/components/slider2';

import './index.css';
import './slides.css';

import 'client/components/main-title/index.css';

import { ProfileData } from 'client/bundles/types';

const b = cn('company-profile');
const bMainTitle = cn('main-title');

const SLIDE_COUNT = 6;
const slideClassnames = Array.from(Array(SLIDE_COUNT).keys())
    .map(value => b('background-slide', { [value + 1]: true }));

interface Props {
    data: ProfileData;
    stocksTeaserUrl: string;
}

class CompanyProfile extends Component<Props> {
    onContactClick = () => {
        const prefooter = document.getElementById('prefooter');

        if (prefooter) {
            prefooter.scrollIntoView({ block: 'end', behavior: 'smooth' });
        }
    }

    render() {
        const { title, text } = this.props.data;

        return (
            <div className={b()}>
                <div className={b('slider')}>
                    <Slider2 classes={slideClassnames} />
                </div>

                <div className={b('content')}>
                    <div className={b('company')}>
                        <article className={b('text')}>
                            <h2 className={bMainTitle()}>{title}</h2>

                            {text}
                        </article>

                        <div className={b('buttons')}>
                            <Button
                                className={b('button')}
                                size="m"
                                type="link"
                                theme="raised"
                                url="/key-businesses"
                                rel="noopener noreferrer"
                                >
                                {'Our Key Businesses'}
                            </Button>

                            <span className={b('button-contact')}>
                                <Button
                                    className={b('button')}
                                    size="m"
                                    onClick={this.onContactClick}
                                    theme="pseudo"
                                    >
                                    {'Contact us'}
                                </Button>
                            </span>
                        </div>
                    </div>

                    <div className={b('widgets')}>
                        <div className={b('stock-data')}>

                            <iframe
                                className={b('stock-data-iframe')}
                                src={this.props.stocksTeaserUrl}
                                height="155"
                                />

                        </div>
                    </div>
                </div>
            </div>
        );
    }
}

export default CompanyProfile;
