import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

import Email from 'client/components/email';
import Phone from 'client/components/phone';

import { OfficeContactsItem } from 'client/bundles/types';

const b = cn('contact');

interface Props {
    contact: OfficeContactsItem;
    contactId?: string | undefined;
}

class Contact extends Component<Props> {

    render() {
        const { phone, title, fax, email, address } = this.props.contact;

        return (
            <div className={b()} id={this.props.contactId}>
                {title && <h5 className={b('title')}>{title}</h5>}

                {address && <div className={b('item')}>{address}</div>}

                {phone && <div className={b('item')}>tel.:&nbsp;<Phone phone={phone} /></div>}

                {fax && <div className={b('item')}>fax:&nbsp;<Phone phone={fax} /></div>}

                {email && <div className={b('item')}><Email email={email} /></div>}
            </div>
        );
    }
}

export default Contact;
