import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

import MenuSection from 'client/components/menu-section';

const b = cn('contacts-governance');
const bPageTitle = cn('page-title');

interface Props {
    title: string;
    pageName: string;
    boardFormUrl: string;
}

class ContactsGovernance extends Component<Props> {

    render() {

        const { title, pageName, boardFormUrl } = this.props;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                <MenuSection type="governance" pageName={pageName} />

                <div className={b('content')}>
                    <h2 className={b('title')}>Contact the Board</h2>

                    <iframe
                        src={boardFormUrl}
                        className={b('iframe')}
                        name="contactBoardForm"
                        />

                </div>
            </div>
        );
    }
}

export default ContactsGovernance;
