import cn from 'client/utils/cn';
import React, { Component } from 'react';

import './index.css';

const b = cn('copy-button');
const BUTTON_HINT = 'Copy to clipboard';
const TOOLTIP_TEXT = 'Copied';
const enum COPYING_STATUS {
    IDLE = 'idle',
    SUCCESS = 'success'
}

interface Props {
    text: string;
    mixClassName?: string;
}

interface State {
    copyingStatus: COPYING_STATUS;
}

class CopyButton extends Component<Props, State> {
    hasClipboardAPI: boolean;

    state = {
        copyingStatus: COPYING_STATUS.IDLE
    };

    constructor(props: Props) {
        super(props);

        this.hasClipboardAPI = typeof window !== 'undefined' && ('clipboard' in window.navigator);

        this.setCopyingStatus = this.setCopyingStatus.bind(this);
        this.copy = this.copy.bind(this);
    }

    setCopyingStatus(copyingStatus: COPYING_STATUS) {
        this.setState({
            copyingStatus
        });
    }

    copy() {
        const { text } = this.props;

        navigator.clipboard
            .writeText(text)
            .then(() => this.setCopyingStatus(COPYING_STATUS.SUCCESS))
            .finally(() => {
                setTimeout(
                    () => this.setCopyingStatus(COPYING_STATUS.IDLE),
                    1500
                );
            });
    }

    render() {
        if (!this.hasClipboardAPI) {
            return null;
        }

        const { mixClassName } = this.props;
        const { copyingStatus } = this.state;
        const isSuccess = copyingStatus === COPYING_STATUS.SUCCESS;

        return (
            <div className={b({}, [mixClassName])}>
                <button className={b('button')} title={BUTTON_HINT} onClick={this.copy} />
                <div className={b('success-tooltip', { shown: isSuccess })}>
                    <span>{TOOLTIP_TEXT}</span>
                </div>
            </div>
        );
    }
}

export default CopyButton;
