import cn from 'client/utils/cn';

import React, { Component } from 'react';

import IconExpand from 'client/components/icon-expand';

import { COMMITTEES, DirectorCommittee, DirectorData } from 'client/bundles/types';

import 'client/components/text/index.css';
import './index.css';

const b = cn('director');

interface Props {
    director: DirectorData;
}

interface State {
    isBioOpened: boolean;
}

class Director extends Component<Props, State> {

    constructor(props: Props) {
        super(props);

        this.state = {
            isBioOpened: false
        };
    }

    toggleBio = () => {
        this.setState({ isBioOpened: !this.state.isBioOpened });
    }

    getCommitteeNames = (committeeTypes: DirectorCommittee[]): string => {
        const names = committeeTypes.map(type => COMMITTEES[type]).join(', ');

        return `${names} Committee${committeeTypes.length > 1 ? 's' : ''}`;
    }

    renderCommittees = () => {
        const { chairpersonCommittees, memberCommittees } = this.props.director;

        return (
            <div className={b('committees')}>
                {chairpersonCommittees.length > 0 ?
                    <div className={b('chairperson')}>
                        {`Chairperson of ${this.getCommitteeNames(chairpersonCommittees)}`}
                    </div> :
                    null
                }
                {memberCommittees.length > 0 ?
                    <div className={b('member')}>
                        {`Member of ${this.getCommitteeNames(memberCommittees)}`}
                    </div> :
                    null
                }
            </div>
        );
    }

    render() {
        const { director } = this.props;

        return (
            <div className={b({ 'opened-bio': this.state.isBioOpened })}>
                <div className={b('info')} onClick={this.toggleBio}>
                    <div className={b('person')}><h2 className={b('name')}>{director.person}</h2></div>
                    <div className={b('role')}>{director.role}</div>
                    {this.renderCommittees()}
                    <div className={b('control')}>
                        <IconExpand opened={this.state.isBioOpened} />
                    </div>
                </div>
                <article className={b('bio')}>
                    <div className={b('bio-inner')}>
                        <div className={b('photo-box')}>
                            <img className={b('photo')} src={director.photo} alt={`${director.person} Photo`} />
                        </div>
                        <div
                            className={b('text', ['text'])}
                            dangerouslySetInnerHTML={{ __html: director.bio }}
                            />
                    </div>
                </article>
            </div>
        );
    }
}

export default Director;
