import cn from 'client/utils/cn';

import React, { ChangeEvent, Component } from 'react';

import Director from 'client/components/director';

import { COMMITTEES, DirectorCommittee, DirectorData, PageDirectorsProps, PageName } from 'client/bundles/types';

import './index.css';

import Select from 'client/components/lego/select';
import MenuSection from 'client/components/menu-section';

interface SelectOption {
    value: DirectorCommittee;
    content: string;
}

const b = cn('directors');
const bPageTitle = cn('page-title');

interface Props extends PageDirectorsProps {
    pageName: PageName;
}

class Directors extends Component<Props> {
    getSelectOptions = (): SelectOption[] => {
        return Object.keys(COMMITTEES).map(committeeType => {
            return {
                value: committeeType,
                content: `${COMMITTEES[committeeType]} Committee${committeeType === 'all' ? 's' : ''}`
            };
        });
    }

    onSelectChange = (event: ChangeEvent<HTMLSelectElement>): void => {
        const url = new URL(window.location.href);

        url.searchParams.set('committee', event.target.value);
        window.document.location.href = url.href;
    }

    renderList = () => {
        return (
            <div className={b('list')}>
                <div className={b('list-head')}>
                    <span className={b('person')}>Name</span>
                    <span className={b('role')}>Title</span>
                    <span className={b('committees')}>
                        <Select
                            size="m"
                            theme="normal"
                            className={b('select')}
                            value={this.props.selectedCommittee || 'all'}
                            options={this.getSelectOptions()}
                            onChange={this.onSelectChange}
                            />

                        <span className={b('committees-title')}>Committee Membership</span>
                    </span>
                    <div className={b('control')} />
                </div>
                <div className={b('list-content')}>
                    {
                        this.props.list.map((listItem: DirectorData, index) => {
                            return this.renderListItem(listItem, index);
                        })
                    }
                </div>
            </div>
        );
    }

    renderListItem = (director: DirectorData, index: number) => {
        return (
            <div className={b('list-item')} key={index}>
                <Director director={director} />
            </div>
        );
    }

    render() {
        const { title, pageName } = this.props;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                <MenuSection type="governance" pageName={pageName} />

                { this.renderList() }
            </div>
        );
    }

}

export default Directors;
