import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { Doc } from 'client/bundles/types';
import './index.css';

const b = cn('docs-list');

type DocsView = 'line';
type DocsTheme = undefined | 'gray';

interface Props {
    docs?: Doc[];
    view?: DocsView;
    theme?: DocsTheme;
}

class DocsList extends Component<Props> {

    renderDoc = (doc: Doc, index: number) => {
        if (!doc.link) {
            return null;
        }

        return (
            <li key={index} className={b('item')}>
                <a className={b('link')} href={doc.link} target={'_blank'}>
                    <i className={b('icon', { 'format': doc.format || 'pdf' })} />
                    <span className={b('title')}>{doc.title || doc.description}</span>
                </a>
            </li>
        );
    }

    render() {
        if (!this.props.docs) {
            return null;
        }

        return (
            <ul className={b('', { 'view': this.props.view, 'theme': this.props.theme })}>
                { this.props.docs.map(this.renderDoc) }
            </ul>
        );
    }

}

export default DocsList;
export { DocsView };
