import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

import IframeXDM from 'client/components/iframeXDM';

const b = cn('email-form');
const bPageTitle = cn('page-title');

interface Props {
    title: string;
    emailFormUrl: string;
}

class EmailForm extends Component<Props> {
    render() {
        return (
            <div className={b('')}>
                <h1 className={bPageTitle({ type: 'border' })}>{this.props.title}</h1>

                <div className={b('content')}>
                    <div className={b('text')}>
                        You may automatically receive Yandex financial information by email.
                        Please enter your preferences for email notifications below.
                    </div>

                    <IframeXDM url={this.props.emailFormUrl} />
                </div>
            </div>
        );
    }
}

export default EmailForm;
