import cn from 'client/utils/cn';

import React, { Component } from 'react';

import 'client/components/date/index.css';
import moment from 'moment';
import './index.css';

import { OccasionData, Time } from 'client/bundles/types';
import DocsList, { DocsView } from 'client/components/docs-list';

const b = cn('events-list');
const bDate = cn('date');
const bTime = cn('time');

interface Props {
    events: OccasionData[];
    docsView?: DocsView;
}

class EventsList extends Component<Props> {
    getDate = (date: string, isDatePeriod?: boolean, isTimePeriod?: boolean) => {
        const formatDate = isDatePeriod && !isTimePeriod ? 'MMMM DD' : 'MMMM DD, YYYY';

        return (
            <span className={bDate()}>
                {moment(date).format(formatDate)}
            </span>
        );
    }

    getTime = (time: Time) => {
        if (!time.value) {
            return null;
        }

        return (
            <span className={bTime()}>
                {moment(time.value, 'HH:mm').format('h:mm A')}
                &nbsp;{time.zone}
            </span>
        );
    }

    renderItem = (item: OccasionData, index: number) => {
        const { title, dateStart, timeStart, dateEnd, timeEnd, location, docs } = item;

        const firstDate = dateStart;
        const isDatePeriod = Boolean(dateStart && dateEnd);
        const isTimePeriod = Boolean(timeStart?.value && timeEnd?.value);

        return (
            <article key={index} className={b('item')}>
                <div className={b('item-top')}>
                    { firstDate &&
                        <span className={b('datetime')}>
                            {this.getDate(firstDate, isDatePeriod, isTimePeriod)}
                            {' '}
                            {timeStart && this.getTime(timeStart)}
                            {dateEnd && <span> &mdash;</span>}
                        </span>
                    }
                    {' '}
                    { dateEnd &&
                        <span className={b('datetime')}>
                            {this.getDate(dateEnd)}
                            {' '}
                            {timeEnd?.value && <span className={bTime()}>{this.getTime(timeEnd)}</span>}
                        </span>
                    }
                </div>

                <div className={b('item-center')}>
                    <h3 className={b('title')}>{title}</h3>
                </div>

                <div className={b('item-bottom')}>
                    { location && <div className={b('location')}>Location: {location}</div> }

                    <DocsList view={this.props.docsView} theme={'gray'} docs={docs} />
                </div>
            </article>
        );
    }

    render() {
        return (
            <div className={b()}>
                { this.props.events.map(this.renderItem) }
            </div>
        );
    }
}

export default EventsList;
