import cn from 'client/utils/cn';

import React, { Component } from 'react';

import EventsList from 'client/components/events-list';

import { PageEventsProps } from 'client/bundles/types';
import { AutoscrollerStoragePrefix } from 'client/components/helpers/autoscroller';
import MenuYears from 'client/components/menu-years';

const b = cn('events');
const bPageTitle = cn('page-title');

type Props = PageEventsProps;

class Events extends Component<Props> {
    render() {
        if (!this.props.yearEvents) {
            return null;
        }

        const { title, yearEvents, years, currentYear } = this.props;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                {currentYear && years && years.length > 0 &&
                    <MenuYears
                        currentYear={currentYear}
                        years={years}
                        storagePrefix={AutoscrollerStoragePrefix.Events}
                        />
                }

                <EventsList
                    docsView="line"
                    events={yearEvents}
                    />
            </div>
        );
    }
}

export default Events;
