import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

import { FaqListItem } from 'client/bundles/types';

import FaqQuestions from 'client/components/faq-questions';
import MenuSection from 'client/components/menu-section';

const b = cn('faq-governance');
const bPageTitle = cn('page-title');

interface Props {
    title: string;
    pageName: string;
    faq?: FaqListItem;
}

class FaqGovernance extends Component<Props> {

    render() {
        if (!this.props.faq) {
            return null;
        }

        const { title, pageName, faq } = this.props;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                <MenuSection type="governance" pageName={pageName} />

                {
                    faq.questions.length ?
                        <div className={b('list')}>
                            { <FaqQuestions questions={faq.questions} />}
                        </div> :
                        null
                }
            </div>
        );
    }
}

export default FaqGovernance;
