import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { FaqQuestionItem } from 'client/bundles/types';

import 'client/components/text/index.css';
import './index.css';

const b = cn('faq-question');

interface Props {
    faqQuestion?: FaqQuestionItem;
}

interface State {
    isAnswerOpened: boolean;
}

class FaqQuestion extends Component<Props, State> {

    constructor(props: Props) {
        super(props);

        this.state = {
            isAnswerOpened: false
        };
    }

    toggleQuestion = () => {
        this.setState({ isAnswerOpened: !this.state.isAnswerOpened });
    }

    renderQuestion = (item: FaqQuestionItem) => {
        const isQuestion = Boolean(item.question);

        return (
            <>
                {
                    item.question ?
                        <div className={b('title')} onClick={this.toggleQuestion}>
                            {item.question}

                            <span className={b('control')} />
                        </div> :
                        null
                }

                <div
                    className={b('answer', { opened: !isQuestion }, ['text'])}
                    dangerouslySetInnerHTML={{ __html: item.answer }}
                    />
            </>
        );
    }

    render() {
        if (!this.props.faqQuestion) {
            return null;
        }

        return (
            <div className={b({ 'opened-answer': this.state.isAnswerOpened })}>
                { this.renderQuestion(this.props.faqQuestion) }
            </div>
        );
    }
}

export default FaqQuestion;
