import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { FaqQuestionItem } from 'client/bundles/types';

import FaqQuestion from 'client/components/faq-question';

import './index.css';

const b = cn('faq-questions');

interface Props {
    questions: FaqQuestionItem[];
}

class FaqQuestions extends Component<Props> {

    renderItem = (item: FaqQuestionItem, i: number) => {
        return (
            <li className={b('item')} key={i}>
                <FaqQuestion faqQuestion={item} />
            </li>);
    }

    render() {
        if (!this.props.questions) {
            return null;
        }

        return (
            <div className={b()}>
                <ul className={b('items')}>
                    { this.props.questions.map((question, i) => this.renderItem(question, i)) }
                </ul>
            </div>
        );
    }
}

export default FaqQuestions;
