import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

import { FaqListItem } from 'client/bundles/types';

import FaqQuestions from 'client/components/faq-questions';
import IconExpand from 'client/components/icon-expand';

const b = cn('faq-section');

interface Props {
    faqItem?: FaqListItem;
}

interface State {
    isItemOpened: boolean;
}

class FaqSection extends Component<Props, State> {

    constructor(props: Props) {
        super(props);

        this.state = {
            isItemOpened: false
        };
    }

    toggleItem = () => {
        this.setState({ isItemOpened: !this.state.isItemOpened });
    }

    renderItem = (item: FaqListItem) => {
        if (item.questions.length === 0) {
            return null;
        }

        return (
            <>
                <div className={b('header')} onClick={this.toggleItem}>
                    {item.title}

                    <span className={b('icon-expand')}>
                        <IconExpand opened={this.state.isItemOpened} />
                    </span>
                </div>

                <FaqQuestions questions={item.questions} />
            </>
        );
    }

    render() {
        if (!this.props.faqItem) {
            return null;
        }

        return (
            <div className={b({ 'opened-item': this.state.isItemOpened })}>
                { this.renderItem(this.props.faqItem) }
            </div>
        );
    }
}

export default FaqSection;
