import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

import { BunkerFaq, FaqListItem } from 'client/bundles/types';

import FaqSection from 'client/components/faq-section';

const b = cn('faq');
const bPageTitle = cn('page-title');

interface Props {
    faq?: BunkerFaq;
}

class Faq extends Component<Props> {
    renderItem = (item: FaqListItem, i: number) => {
        return (
            <FaqSection faqItem={item} key={i} />
        );
    }

    render() {
        if (!this.props.faq) {
            return null;
        }

        const { title, list } = this.props.faq;

        return (
            <div className={b()}>
                <h1 className={bPageTitle({ type: 'border' })}>{title}</h1>

                <div className={b('list')}>
                    { list.map((item, i) => this.renderItem(item, i))}
                </div>
            </div>
        );
    }
}

export default Faq;
