import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { PageFinancialsProps } from 'client/bundles/types';

import 'client/components/text/index.css';
import './index.css';

import Breadcrumbs from 'client/components/breadcrumbs';
import DocsList from 'client/components/docs-list';
import moment from 'moment';

const b = cn('financial');
const bPageTitle = cn('page-title');

interface Props extends Omit<PageFinancialsProps, 'years'> {
    baseUrl: string;
}

class Financial extends Component<Props> {

    render() {
        const { quarterReport, currentYear, baseUrl, title } = this.props;

        if (!quarterReport || !quarterReport.html) {
            return null;
        }

        return (
            <div className={b()}>
                <Breadcrumbs text={title} link={`${baseUrl}?year=${currentYear}`} />

                <h1 className={bPageTitle()}>{quarterReport.title}</h1>

                <div className={b('content')}>
                    <div className={b('content-docs')}>
                        <DocsList view="line" docs={quarterReport.docs} />
                    </div>

                    <div className={b('content-text')}>
                        <div className={b('date')}>
                            {moment(quarterReport.date).format('MMMM DD, YYYY')}
                        </div>

                        <div
                            className={b('report', ['text'])}
                            dangerouslySetInnerHTML={{ __html: quarterReport.html }}
                            />
                    </div>
                </div>
            </div>
        );
    }

}

export default Financial;
