import cn from 'client/utils/cn';

import React, { Component } from 'react';

import 'client/components/date/index.css';
import moment from 'moment';
import './index.css';

import DocsList from 'client/components/docs-list';

import { BunkerFinancialType, BunkerFinancialYear } from 'client/bundles/types';

const b = cn('financials-list');
const bDate = cn('date');

interface Props {
    financials: BunkerFinancialYear;
}

class FinancialsList extends Component<Props> {
    onItemClick = (url: string) => {
        window.document.location.href = url;
    }

    onDocsClick = (e: React.MouseEvent<HTMLDivElement, MouseEvent>) => {
        e.stopPropagation();
    }

    getDate = (date: string) => {
        const formatDate = 'MMMM DD, YYYY';

        return (
            <span className={bDate()}>
                {moment(date).format(formatDate)}
            </span>
        );
    }

    renderItem = (key: BunkerFinancialType, index: number) => {
        if (!this.props.financials) {
            return null;
        }

        const item = this.props.financials[key];
        const { date, docs, url } = item;

        return (
            <article
                key={index}
                className={b('item')}
                /* eslint-disable-next-line react/jsx-no-bind */
                onClick={() => this.onItemClick(url)}
                >
                <div className={b('top')}>
                    <h2 className={b('title')}>
                        <a
                            className={b('title-link')}
                            href={url}
                            >
                            {key}
                        </a>
                    </h2>
                </div>

                <div className={b('bottom')}>
                    <div className={b('docs')} onClick={this.onDocsClick}>
                        <DocsList theme={'gray'} docs={docs} />
                    </div>

                    <div className={b('date')}>
                        {this.getDate(date)}
                    </div>
                </div>
            </article>
        );
    }

    render() {
        return (
            <div className={b()}>
                { Object.keys(this.props.financials).map(this.renderItem) }
            </div>
        );
    }

}

export default FinancialsList;
