import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { PageFinancialsProps } from 'client/bundles/types';

import FinancialsList from 'client/components/financials-list';
import { AutoscrollerStoragePrefix } from 'client/components/helpers/autoscroller';
import MenuYears from 'client/components/menu-years';

const b = cn('financials');
const bPageTitle = cn('page-title');

class Financials extends Component<PageFinancialsProps> {
    render() {
        const { title, yearReports, years, currentYear } = this.props;

        if (!yearReports) {
            return null;
        }

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                {currentYear && years && years.length > 0 &&
                    <MenuYears
                        currentYear={currentYear}
                        years={years}
                        storagePrefix={AutoscrollerStoragePrefix.Financials}
                        />
                }

                <FinancialsList financials={yearReports} />
            </div>
        );
    }

}

export default Financials;
