import cn from 'client/utils/cn';

import SiteMenu from 'client/components/site-menu';
import React, { Component } from 'react';

import 'client/components/nav/index.css';
import './index.css';

import { MenuItem, Service, ServiceItem } from 'client/bundles/types';

const b = cn('header');
const bNav = cn('nav');

const SERVICES: Service[] = [
    {
        ir: { href: 'https://ir.yandex', title: 'For Investors' },
        isActive: true
    },
    {
        company: { href: 'https://yandex.com/company', title: 'Company' }
    },
    {
        vacancies: { href: 'https://yandex.com/jobs', title: 'Jobs' }
    },
    {
        tech: { href: 'https://tech.yandex.com', title: 'For Developers' }
    },
    {
        adv: { href: 'https://yandex.com/adv', title: 'For Advertisers' }
    },
    {
        events: { href: 'https://events.yandex.com/events', title: 'Events' }
    },
    {
        science: { href: 'https://research.yandex.com', title: 'Research' }
    }
];

interface Props {
    items: MenuItem[];
    isTestingEnv: boolean;
    isMenuOpened: boolean;
    onNavToggled: (opened: boolean) => void;
}

class Header extends Component<Props> {
    toggleMenu = () => {
        this.props.onNavToggled(!this.props.isMenuOpened);
    }

    renderSiteMenu = () => {
        return <SiteMenu items={this.props.items} />;

    }

    renderAllServices = () => {
        return (SERVICES.map((serviceItem: Service) => {
            const service = Object.keys(serviceItem)[0] as ServiceItem;

            return this.renderServiceLink(service);
        }));
    }

    renderServiceLink = (service: ServiceItem) => {
        const currentService = SERVICES.find(serviceItem => Boolean(serviceItem[service]));
        const link = currentService && currentService[service];

        if (!currentService || !link) {
            return;
        }

        return (
            <a
                href={link.href}
                key={service}
                className={b('service', { active: currentService.isActive })}
                >
                { link.title }
            </a>
        );
    }

    renderServicesMenu = () => {
        return (
            <nav
                className={b('navigation')}
                >
                { this.renderAllServices() }
            </nav>);
    }

    renderHeader = () => {
        return (
            <div className={b()}>
                {
                    this.props.isTestingEnv &&
                        <div className={b('testing-line')}>Testing version</div>
                }
                <header className={b('main')}>
                    <div className={b('logo')}>
                        <a className={b('logo-link')} href="https://yandex.com">Yandex</a>
                    </div>
                    <div className={b('services')}>
                        {this.renderServicesMenu()}
                    </div>
                    <div className={b('nav')} onClick={this.toggleMenu} />
                </header>
                {this.renderSiteMenu()}
            </div>
        );
    }

    renderNav = () => {
        return (
            <div className={bNav({ opened: this.props.isMenuOpened })}>
                <div className={bNav('pannel')}>
                    <div className={bNav('close')} onClick={this.toggleMenu} />

                    <div className={bNav('inner')}>
                        <div className={bNav('site-menu')}>
                            {this.renderSiteMenu()}
                        </div>

                        <div className={bNav('services-wrap')}>
                            <div className={bNav('services-scroller')}>
                                <header className={bNav('services')}>
                                    {this.renderServicesMenu()}
                                </header>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        );
    }

    render() {
        return (
            <>
                { this.renderHeader() }

                { this.renderNav() }
            </>
        );
    }
}

export default Header;
