import React, { Component, Fragment, ReactNode } from 'react';

export type RenderButtonType = (toggle: () => void, cutted: boolean) => ReactNode;

interface Props {
    count: number;
    renderButton: RenderButtonType;
}

interface State {
    cutted: boolean;
}

class Cut extends Component<Props, State> {
    state = {
        cutted: true
    };

    constructor(props: Props) {
        super(props);

        this.toggleState = this.toggleState.bind(this);
    }

    render() {
        const { cutted } = this.state;
        const { children, count } = this.props;

        return (
            <Fragment>
                {cutted ? React.Children.toArray(children).slice(0, count) : children}
                {this.props.renderButton(this.toggleState, cutted)}
            </Fragment>
        );
    }

    private toggleState() {
        this.setState(({ cutted }) => ({
            cutted: !cutted
        }));
    }
}

export default Cut;
