import React, { Component } from 'react';

const TOUCH_EVENTS = ['touchend'];

class DropTouchEvents extends Component<{}> {
    private static dropEvent(e: Event) {
        e.preventDefault();
        e.stopPropagation();
    }

    private root = React.createRef<HTMLDivElement>();

    componentDidMount() {
        if (!this.root.current) {
            return;
        }

        // Отменяет любые действия с блоком на мобилке
        for (const eventName of TOUCH_EVENTS) {
            this.root.current.addEventListener(eventName, DropTouchEvents.dropEvent, true);
        }
    }

    componentWillUnmount() {
        if (!this.root.current) {
            return;
        }

        for (const eventName of TOUCH_EVENTS) {
            this.root.current.removeEventListener(eventName, DropTouchEvents.dropEvent);
        }
    }

    render() {
        return <div ref={this.root}>{this.props.children}</div>;
    }
}

export default DropTouchEvents;
