import cn from 'client/utils/cn';

import React, { Component } from 'react';

const b = cn('iframeXDM');

interface Props {
    url: string;
}

class IframeXDM extends Component<Props> {
    // fake typing for supressing error
    private transport: Record<string, string>;

    componentDidMount() {
        this.initXDM();
    }

    componentDidUpdate() {
        this.initXDM();
    }

    initXDM = () => {
        if (!window.easyXDM || this.transport) {
            return;
        }

        this.transport = new window.easyXDM.Socket({
            remote: this.props.url,
            container: 'embedded',
            onMessage(message: string) {
                this.container.getElementsByTagName('iframe')[0].style.height = `${message}px`;
                this.container.getElementsByTagName('iframe')[0].scrolling = 'no';
                this.container.getElementsByTagName('iframe')[0].style.width = '100%';
            }
        });
    }

    render() {
        return (
            <div className={b()}>
                <div id="embedded" />
            </div>
        );
    }
}

export default IframeXDM;
