import { BundleData } from 'client/bundles/types';
import Breadcrumbs from 'client/components/breadcrumbs';
import cn from 'client/utils/cn';

import React, { Component } from 'react';

import StructureNode from './structure-node';

import './index.css';

import 'client/components/wiki-text/index.css';

const b = cn('key-businesses');
const bPageTitle = cn('page-title');

interface Props {
    title: string;
    note: string;
    structure: BundleData['keyBusinesses']['structure'];
}

class KeyBusinesses extends Component<Props> {
    render() {
        const { title, structure, note } = this.props;

        return (
            <section className={b()}>
                <header className={b('header')}>
                    <Breadcrumbs link="/" text={'IR Home'} />

                    <h1 className={bPageTitle()}>{title}</h1>
                </header>
                <section className={b('structure')}>
                    {structure.map(
                        segment => <StructureNode key={segment.title} node={segment} />
                    )}
                </section>

                {
                    note ?
                        <div className={b('note')} dangerouslySetInnerHTML={{ __html: note }} /> :
                        null
                }
            </section>
        );
    }
}

export default KeyBusinesses;
