import cn from 'client/utils/cn';

import React, { Component } from 'react';

import DocsList from 'client/components/docs-list';

import { BunkerDocuments, PageName } from 'client/bundles/types';
import './index.css';

import MenuSection from 'client/components/menu-section';

const b = cn('key-documents');
const bPageTitle = cn('page-title');

interface Props {
    documents?: BunkerDocuments;
    title: string;
    pageName: PageName;
}

class KeyDocuments extends Component<Props> {

    render() {
        if (!this.props.documents) {
            return null;
        }

        const { corporateDocs, chartersDocs } = this.props.documents;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{this.props.title}</h1>

                <MenuSection type="governance" pageName={this.props.pageName} />

                <div className={b('list')}>
                    <div className={b('item')}><DocsList docs={corporateDocs} /></div>
                    <div className={b('item')}><DocsList docs={chartersDocs} /></div>
                </div>
            </div>
        );
    }

}

export default KeyDocuments;
