import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { BunkerLatestPresentation } from 'client/bundles/types';
import Breadcrumbs from 'client/components/breadcrumbs';
import DocsList from 'client/components/docs-list';

const b = cn('latest-presentation');
const bPageTitle = cn('page-title');

interface Props {
    latestPresentation?: BunkerLatestPresentation;
}

class LatestPresentation extends Component<Props> {

    render() {
        if (!this.props.latestPresentation) {
            return null;
        }

        const { title, text, docs } = this.props.latestPresentation;

        return (
            <div className={b()}>
                <Breadcrumbs link="/" text={'IR Home'} />

                <h1 className={bPageTitle({ type: 'border' })}>{title}</h1>

                {text}

                <DocsList docs={docs} />
            </div>
        );
    }
}

export default LatestPresentation;
