import { compose } from '@bem-react/core';
import { Registry, withRegistry } from '@bem-react/di';
import {
    Button as BaseButton,
    withSizeM as withButtonSizeM,
    withThemeNormal as withButtonThemeNormal,
    withViewDefault as withButtonViewDefault
} from '@yandex-lego/components/Button/desktop';
import {
    Icon as BaseIcon,
    withGlyphCaretsV,
    withTypeArrow
} from '@yandex-lego/components/Icon/desktop';
import {
    Menu as BaseMenu,
    withSizeM as withMenuSizeM,
    withThemeNormal as withMenuThemeNormal,
    withViewDefault as withMenuViewDefault
} from '@yandex-lego/components/Menu/desktop';
import {
    Popup as BasePopup,
    withTargetAnchor,
    withThemeNormal as withPopupThemeNormal,
    withViewDefault as withPopupViewDefault
} from '@yandex-lego/components/Popup/desktop';
import { cnSelect, Option, Select as BaseSelect } from '@yandex-lego/components/Select/desktop';
import { withOutsideClick } from '@yandex-lego/components/withOutsideClick';
import { withTogglable } from '@yandex-lego/components/withTogglable';

import './index.css';

const Icon = compose(
    withTypeArrow,
    withGlyphCaretsV
)(BaseIcon);

const Button = compose(
    withButtonSizeM,
    withButtonThemeNormal,
    withButtonViewDefault
)(BaseButton);

const Popup = compose(
    withPopupViewDefault,
    withOutsideClick,
    withTargetAnchor,
    withPopupThemeNormal
)(BasePopup);

const Menu = compose(
    withMenuThemeNormal,
    withMenuViewDefault,
    withMenuSizeM
)(BaseMenu);

const selectRegistry = new Registry({ id: cnSelect() });

selectRegistry
    .set('Trigger', Button)
    .set('Popup', Popup)
    .set('Menu', Menu)
    .set('Icon', Icon);

const Select = compose(
    withRegistry(selectRegistry),
    withTogglable
)(BaseSelect);

export default Select;
export { Option };
