import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { MainInfoData } from 'client/bundles/types';

import ReadMore from 'client/components/read-more';

import './index.css';

import 'client/components/main-title/index.css';

const b = cn('main-info');
const bMainTitle = cn('main-title');

interface Props {
    data: MainInfoData;
}

class MainInfo extends Component<Props> {

    render() {
        const { title, link, text } = this.props.data;

        return (
            <article className={b()}>
                <h3 className={bMainTitle()}>{title}</h3>

                <div className={b('description')}>
                    {text}

                    <ReadMore link={link} />
                </div>
            </article>
        );
    }
}

export default MainInfo;
