import cn from 'client/utils/cn';

import React, { Component } from 'react';

import Button from 'client/components/lego/button';

import { MainLink } from 'client/bundles/types';

import './index.css';

import 'client/components/main-title/index.css';

const b = cn('main-links');

interface Props {
    links: MainLink[];
}

class MainLinks extends Component<Props> {
    renderLink = (link: MainLink, i: number) => {
        return (
            <div className={b('item')} key={i}>
                <Button
                    className={b('button')}
                    size="m"
                    type="link"
                    url={link.url}
                    target={link.isTargetBlank ? '_blank' : undefined}
                    rel="noopener noreferrer"
                    >
                    {link.title}
                </Button>
            </div>
        );
    }

    render() {
        return (
            <div className={b()}>
                { this.props.links.map(this.renderLink) }
            </div>
        );
    }
}

export default MainLinks;
