import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { PageMainProps } from 'client/bundles/types';
import CompanyProfile from 'client/components/company-profile';
import FinancialsList from 'client/components/financials-list';
import MainInfo from 'client/components/main-info';
import MainLinks from 'client/components/main-links';
import MapYandexGeography from 'client/components/map-yandex-geography';
import PressReleaseItem from 'client/components/press-release-item';
import ReadMore from 'client/components/read-more';

import './index.css';

import 'client/components/main-title/index.css';

const b = cn('main');
const bMainTitle = cn('main-title');

class Main extends Component<PageMainProps> {

    render() {
        const { history, profile, links, pressReleases, principles, lastFinancialReports, geography, stocksTeaserUrl } = this.props;

        return (
            <div className={b('')}>
                <CompanyProfile data={profile} stocksTeaserUrl={stocksTeaserUrl} />

                <div className={b('top')}>
                    <div className={b('links')}>
                        <MainLinks links={links} />
                    </div>

                    <div className={b('releases')}>
                        <div className={b('financials')}>
                            {/* TODO вынести в данные */}
                            <h2 className={bMainTitle()}>Financial Reports</h2>

                            <FinancialsList financials={lastFinancialReports} />

                            <ReadMore link={'/financial-releases'} />
                        </div>

                        {pressReleases && pressReleases.length > 0 &&
                            <div className={b('news')}>
                                {/* TODO вынести в данные */}
                                <h2 className={bMainTitle()}>Press Releases</h2>

                                {pressReleases.map(item => (<PressReleaseItem release={item} key={item.date} />))}

                                <ReadMore link={'/press-releases'} />
                            </div>
                        }
                    </div>
                </div>

                <div className={b('bottom')}>
                    {
                        history.isVisible &&
                            <div className={b('history')}>
                                <MainInfo data={history} />
                            </div>
                    }

                    {
                        geography.isVisible &&
                            <div className={b('geography')} id={'map'}>
                                <MapYandexGeography data={geography} />
                            </div>
                    }

                    {
                        principles.isVisible &&
                            <div className={b('principles')}>
                                <MainInfo data={principles} />
                            </div>
                    }
                </div>
            </div>
        );
    }
}

export default Main;
