import cn from 'client/utils/cn';

import React, { Component } from 'react';

import { BunkerManagement, PageName, PersonInfo } from 'client/bundles/types';

import './index.css';

import MenuSection from 'client/components/menu-section';
import Person from 'client/components/person';

const b = cn('management');
const bPageTitle = cn('page-title');

interface Props {
    title: string;
    pageName: PageName;
    management: BunkerManagement;
}

class Management extends Component<Props> {

    renderItem = (item: PersonInfo, index: number) => {
        return <Person person={item} key={index} />;
    }

    render() {
        const { title, pageName, management } = this.props;

        return (
            <div className={b()}>
                <h1 className={bPageTitle()}>{title}</h1>

                <MenuSection type="governance" pageName={pageName} />

                <div className={b('persons')}>
                    {management.list.map((item, i) => this.renderItem(item, i))}
                </div>
            </div>
        );
    }

}

export default Management;
