import { BundleData } from 'client/bundles/types';
import cn from 'client/utils/cn';
import React, { Component } from 'react';

import Cut, { RenderButtonType } from 'client/components/helpers/cut';

import CountryDescriptor from '../country-descriptor';

import './index.css';

type Size = [number, number];

const b = cn('adaptive-country-list');

interface Props {
    countries: BundleData['main']['geography']['countries'];
}

class AdaptiveCountryList extends Component<Props> {
    picRef = React.createRef<HTMLDivElement>();
    reducedCountriesCoords: Size[] = [];

    render() {
        const { countries } = this.props;

        return (
            <Cut count={1} renderButton={this.renderCutButton}>
                {countries.map(({ country, description }) => (
                    <div key={country} className={b('item')}>
                        <CountryDescriptor country={country} description={description} />
                    </div>
                ))}
            </Cut>
        );
    }

    private renderCutButton: RenderButtonType = (toggle, cutted) => {
        return (
            <button className={b('cut-button')} onClick={toggle}>
                {cutted ? 'Open full list' : 'Hide full list'}
            </button>
        );
    }
}

export default AdaptiveCountryList;
