import cn from 'client/utils/cn';
import React, { Component } from 'react';

import Hint from 'client/components/hint';

import CountryDescriptor from '../country-descriptor';

import './index.css';

const b = cn('country-badge');
const HINT_WIDTH = 300;

interface Props {
    badgeStyle: string;
    country: string;
    type: string;
    description: string;
    coordinates: [number, number];
}

class CountryBadge extends Component<Props> {
    private badgeRef = React.createRef<HTMLDivElement>();

    componentDidMount() {
        // Прокидываем актуальный badgeRef в Hint после отрисовки
        this.forceUpdate();
    }

    render() {
        const { badgeStyle, country, description, coordinates, type } = this.props;
        const [x, y] = coordinates;

        return (
            <div
                ref={this.badgeRef}
                className={b({ type })}
                style={{
                    backgroundImage: `url(${badgeStyle})`,
                    left: `${x}%`,
                    top: `${y}%`
                }}
                >
                <Hint
                    mixClassName={b('hint')}
                    parentNode={this.badgeRef.current}
                    width={HINT_WIDTH}
                    >
                    <CountryDescriptor country={country} description={description} />
                </Hint>
            </div>
        );
    }
}

export default CountryBadge;
