import cn from 'client/utils/cn';
import React, { Component } from 'react';

import './index.css';

const b = cn('country-descriptor');

interface Props {
    country: string;
    description: string;
}

class CountryDescriptor extends Component<Props> {
    render() {
        const { country, description } = this.props;

        return (
            <section className={b()}>
                <h3 className={b('hint-title')}>{country}</h3>
                <div className={b('hint-content')}>{description}</div>
            </section>
        );
    }
}

export default CountryDescriptor;
