import cn from 'client/utils/cn';

import React, { Component } from 'react';

import 'client/components/date/index.css';
import moment from 'moment';
import './index.css';

import { OccasionData } from 'client/bundles/types';
import DocsList, { DocsView } from 'client/components/docs-list';

const b = cn('meetings-list');
const bDate = cn('date');

interface Props {
    occasions: OccasionData[];
    docsView?: DocsView;
}

class MeetingsList extends Component<Props> {
    getDate = (date: string) => {
        return (
            <span className={bDate()}>
                {moment(date).format('MMMM DD')}
            </span>
        );
    }

    getYear = (date: string) => {
        return (
            <div className={b('year')}>
                {moment(date).format('YYYY')}
            </div>
        );
    }

    renderItem = (item: OccasionData, index: number) => {
        const { dateStart, location, docs } = item;

        return (
            <article key={index} className={b('item')}>
                <div className={b('item-left')}>
                    {this.getYear(dateStart)}
                    <div className={b('details')}>
                        <span className={b('date')}>
                            {this.getDate(dateStart)}
                        </span>
                        { location && <span className={b('location')}>, {location}</span> }
                    </div>
                </div>

                <div className={b('item-right')}>
                    <DocsList view={this.props.docsView} docs={docs} />
                </div>
            </article>
        );
    }

    render() {
        return (
            <div className={b()}>
                { this.props.occasions.map(this.renderItem) }
            </div>
        );
    }
}

export default MeetingsList;
