import cn from 'client/utils/cn';

import React, { ChangeEvent, Component } from 'react';

import MeetingsList from 'client/components/meetings-list';
import MenuSection from 'client/components/menu-section';

import { BunkerMeetings, PageName, TypeMeetingData, TypeMeetingId } from 'client/bundles/types';
import './index.css';

import Select from 'client/components/lego/select';

const b = cn('meetings');
const bPageTitle = cn('page-title');

interface Props {
    meetings?: BunkerMeetings;
    title: string;
    pageName: PageName;
}

interface State {
    selectValue: string;
}

const SELECT_OPTIONS = [
    {
        value: 'all',
        content: 'All Shareholder Meetings'
    },
    {
        value: 'annual',
        content: 'Annual General Meetings'
    },
    {
        value: 'extraordinary',
        content: 'Extraordinary General Meetings'
    }
];

class Meetings extends Component<Props, State> {

    constructor(props: Props) {
        super(props);

        this.state = {
            selectValue: 'all'
        };
    }

    onSelectChange = (event: ChangeEvent<HTMLSelectElement>): void => {
        this.setState({ selectValue: event.target.value });
    }

    renderMeeting = (meetingType: TypeMeetingData, meetingId: TypeMeetingId) => {
        const { title, list } = meetingType;

        if (!list || list.length === 0) {
            return null;
        }

        return (
            <div className={b('item', { type: meetingId })}>
                <h2 className={b('item-title')}>{title}</h2>

                <MeetingsList occasions={list} />
            </div>
        );
    }

    render() {
        if (!this.props.meetings) {
            return null;
        }

        const { egm, agm } = this.props.meetings;

        return (
            <div className={b({ type: this.state.selectValue })}>
                <h1 className={bPageTitle()}>{this.props.title}</h1>

                <MenuSection type="shareholders" pageName={this.props.pageName} />

                <Select
                    size="m"
                    theme="normal"
                    className={b('select')}
                    value={this.state.selectValue}
                    options={SELECT_OPTIONS}
                    onChange={this.onSelectChange}
                    />

                {this.renderMeeting(agm, 'annual')}
                {this.renderMeeting(egm, 'extraordinary')}
            </div>
        );
    }

}

export default Meetings;
