import cn from 'client/utils/cn';

import React, { Component } from 'react';

import './index.css';

import { MenuItemLink, MenuItems, PAGES } from 'client/utils/menu-utils';

const b = cn('menu-section');

interface Props {
    type: 'shareholders' | 'principles' | 'governance';
    noBorder?: boolean;
    pageName: string;
}

interface State {
    isMenuOpened: boolean;
}

class MenuSection extends Component<Props, State> {
    constructor(props: Props) {
        super(props);

        this.state = {
            isMenuOpened: false
        };
    }

    toggleMenu = () => {
        this.setState({ isMenuOpened: !this.state.isMenuOpened });
    }

    getItems = (): MenuItems => {
        return PAGES[this.props.type];
    }

    renderAdaptiveContent = () => {
        const { pageName } = this.props;
        const allItems = this.getItems();
        const pageTitle = allItems[pageName]?.title;
        const items = { ...allItems };

        delete items[pageName];

        return (
            <>
                <div className={b('title')}>
                    {pageTitle}
                    <span className={b('arrow')} />
                </div>
                {this.renderItems(items)}
            </>
        );
    }

    renderItems = (items: MenuItems) => {
        const itemNames = Object.keys(items);

        return (
            <div className={b('items')}>
                {itemNames.map(itemName => this.renderMenuLink(items[itemName], itemName))}
            </div>
        );
    }

    renderMenuLink = (itemData: MenuItemLink, pageId: string) => {
        const { title, href } = itemData;

        return (
            <a
                href={href}
                key={pageId}
                className={b('item', { active: pageId === this.props.pageName })}
                >
                { title }
            </a>
        );
    }

    render() {
        const items = this.getItems();

        return (
            <div className={b({ 'no-border': this.props.noBorder })}>
                <div className={b('regular')}>
                    {this.renderItems(items)}
                </div>
                <div
                    className={b('adaptive', { opened: this.state.isMenuOpened })}
                    onClick={this.toggleMenu}
                    >
                    {this.renderAdaptiveContent()}
                </div>
            </div>
        );
    }
}

export default MenuSection;
