import cn from 'client/utils/cn';
import React, { Component } from 'react';

import Autoscroller, { AutoscrollerStoragePrefix, ClickEffect } from '../helpers/autoscroller';

import './index.css';

const b = cn('menu-years');

interface Props {
    currentYear: string;
    years: string[];
    storagePrefix: AutoscrollerStoragePrefix;
}

class MenuYears extends Component<Props> {
    scrolledYear = React.createRef<HTMLDivElement>();
    scroller = React.createRef<HTMLDivElement>();

    getYears = (years: string[], onClickEffect: ClickEffect) => {
        return years.map((year, i) => {
            return this.renderYear(year, i, onClickEffect);
        });
    }

    renderYear = (year: string, index: number, onClickEffect: ClickEffect) => {
        const { currentYear } = this.props;
        const isCurrent = year === currentYear;

        const onClick = () => {
            onClickEffect(year);
            this.requestFilteredData(year);
        };

        return (
            <span
                ref={isCurrent && index !== 0 ? this.scrolledYear : undefined}
                /* eslint-disable-next-line react/jsx-no-bind */
                onClick={onClick}
                key={year}
                className={b('year', { active: isCurrent })}
                >
                {year}
            </span>
        );
    }

    requestFilteredData = (value: string): void => {
        const url = new URL(window.location.href);

        url.searchParams.set('year', value);
        window.document.location.href = url.href;
    }

    checkYearMatch = (value: string) => {
        return this.props.currentYear === value;
    }

    componentDidMount() {
        // Прокидываем актуальные refы в Autoscroller после отрисовки
        this.forceUpdate();
    }

    render() {
        const { years, storagePrefix } = this.props;

        return (
            <Autoscroller
                prefix={storagePrefix}
                currentMenuItem={this.scrolledYear.current}
                scroller={this.scroller.current}
                scrollProperty="scrollTop"
                compare={this.checkYearMatch}
                >
                {onClickEffect => (
                    <div className={b()}>
                        <div className={b('scroll-wrapper')}>
                            <div className={b('scroller')} ref={this.scroller}>
                                {this.getYears(years, onClickEffect)}
                            </div>
                        </div>
                    </div>
                )}
            </Autoscroller>
        );
    }

}

export default MenuYears;
