import React, { Component } from 'react';
import { YMInitializer } from 'react-yandex-metrika';

import { MetrikaData } from 'client/bundles/types';

interface Props {
    metrika?: MetrikaData;
}

class Metrika extends Component<Props> {
    render() {
        const { metrika } = this.props;

        if (!metrika) {
            return null;
        }

        return (
            <YMInitializer
                accounts={[metrika.metrikaId]}
                options={metrika.metrikaOptions}
                />
        );
    }
}

export default Metrika;
